// RunUO 2.0 Venus Dzenlemesi <venus@ultima-strike.com>

using System;
using Server; 
using Server.Items; 
using Server.Mobiles; 
using Server.Targeting; 
using Server.Commands;

namespace Server.PlayerCommands
{ 
	public class BandageSelf
	{
		public static void Initialize() 
		{
			CommandSystem.Register( "BandageSelf", AccessLevel.Player, new CommandEventHandler( BandageSelfCommand ) );
			CommandSystem.Register( "Band", AccessLevel.Player, new CommandEventHandler( BandCommand ) );
		}
		[Usage( "BandageSelf" )] 
		public static void BandageSelfCommand( CommandEventArgs e ) 
		{
			if ( e.Mobile != null && e.Mobile.Hits == e.Mobile.HitsMax )
			{
				e.Mobile.SendLocalizedMessage( 500955 );
				return;
			}
			if ( e.Mobile != null && e.Mobile.Backpack != null )
			{
				Bandage bandage = (Bandage)(e.Mobile.Backpack).FindItemByType( typeof( Bandage ) );
				if ( bandage != null )
				{
					BandageContext.BeginHeal( e.Mobile, e.Mobile );
					bandage.Consume();
				}
				else
					e.Mobile.SendMessage("antanzda bandaj yok!");
			}
		}
		[Usage( "Band" )] 
		public static void BandCommand( CommandEventArgs e ) 
		{
			e.Mobile.Target = new BandTarget( e.Mobile );
		}
		public class BandTarget : Target
		{
			private static Mobile m_from;
			public BandTarget( Mobile from ) : base( -1, false, TargetFlags.None )
			{
				from.SendMessage("Can basmak istediiniz kiiyi tklayn...");
				m_from = from;
			}
			protected override void OnTarget( Mobile from, object o )
			{
				if ( o is Mobile )
				{
					Mobile mobile = (Mobile)o;
					Bandage bandage = (Bandage)(from.Backpack).FindItemByType( typeof( Bandage ) );
					if ( bandage != null )
					{
						BandageContext.BeginHeal( from, mobile );
						bandage.Consume();
					}
					else
						from.SendMessage("antanzda bandaj yok!");
				}
			}
		}
	}
}