// RunUO 2.0 Venus Dzenlemesi <venus@ultima-strike.com>

using System;
using Server; 
using Server.Items; 
using Server.Mobiles; 
using Server.Targeting;
using Server.Commands;

namespace Server.Scripts.Commands 
{ 
	public class BondedTime
	{
		public static void Initialize() 
		{
			CommandSystem.Register( "Bonded", AccessLevel.Player, new CommandEventHandler( BondedCommand ) );
		}
		[Usage( "Bonded" )] 
		public static void BondedCommand( CommandEventArgs e ) 
		{
			e.Mobile.Target = new BondedTarget( e.Mobile );
		}
		public class BondedTarget : Target
		{
			public BondedTarget( Mobile from ) : base( -1, false, TargetFlags.None )
			{
				from.SendMessage("Bonded sresini renmek istediiniz hayvan tklayn...");
			}
			protected override void OnTarget( Mobile from, object o )
			{
				if ( o is BaseCreature && ((BaseCreature)o).Controlled && ((BaseCreature)o).ControlMaster == from )
				{
					BaseCreature pet = (BaseCreature)o;
					DateTime zaman = pet.BondingBegin;
					if ( zaman == DateTime.MinValue )
						from.SendMessage( 1150, "Bonded sreci balamam ya da zaten bonded bir hayvan iaretlediniz.." );
					else
					{
						from.SendMessage( 1161, zaman.AddDays( 1 ).ToString() + " tarihinde bonded olacak." );
						from.SendMessage( 1150, "Uyar: Eer bu zamana kadar yeterli beslemez ya da skill deiiklii olursa sfrlanr." );
					}
				}
			}
		}
	}
}