// RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

// Oyun yaplandrmasnda yardmc olur.

using System;
using System.IO;
using System.Collections;
using Server; 
using Server.Items; 
using Server.Mobiles; 
using Server.Network;
using Server.Gumps;
using Server.Commands;

namespace Server.Misc
{ 
	public class Hazirla
	{
		public static bool Completed = false;

		public static void Initialize()
		{
			EventSink.Login += new LoginEventHandler( Prepare );
		}
		private static void Prepare( LoginEventArgs e )
		{
			if ( e.Mobile == null || Completed )
				return;

			if ( e.Mobile.AccessLevel == AccessLevel.Owner )
			{
				e.Mobile.CloseGump( typeof( PrepareGump ) );
				e.Mobile.SendGump( new PrepareGump( e.Mobile ) );
			}
		}
		public class PrepareGump : Gump
		{
			public PrepareGump( Mobile from ) : base(0, 0)
			{
				Closable = false;
				Disposable = false;
				Dragable = false;
				Resizable = false;

				AddPage(0);
				AddBackground(50, 50, 440, 260, 9270);
				AddImageTiled(61, 60, 416, 240, 2624);
				AddLabel(124, 67, 1160, @"Venus Ultima (Age of Shadows) - Oyun Kurulumu");
				AddHtml( 70, 97, 400, 163, @"Bu pencere sadece Venus Ultima ilk kez aldnda giri yapan yneticiye grnr. Dnyann dekorasyonu, yaratklar, satclar ve ampiyonlarn otomatik olarak oluturup sunucunuzu kullanma hazr hale getirir.<br /><br />Eer kurulumu kendiniz yapmak istiyorsanz iptal butonuna basn. Ama unu unutmayn bu pencere tekrar size gsterilmeyecektir.", true, true);
				AddButton(72, 268, 4005, 4007, 1, GumpButtonType.Reply, 0);
				AddLabel(110, 270, 1149, @"Kuruluma Bala");
				AddButton(274, 268, 4005, 4007, 0, GumpButtonType.Reply, 0);
				AddLabel(312, 270, 1149, @"Kendim Yapacam");
			}
			public override void OnResponse( NetState state, RelayInfo info )
			{
				if ( state.Mobile == null )
					return;

				Hazirla.Completed = true;

				if ( info.ButtonID == 1 )
				{
					state.Mobile.SendMessage( "Kurulum balyor... Bu ilem birka dakika srebilir, bu sre ierisinde ltfen oyundan kmayn." );

					CommandSystem.Handle( state.Mobile, String.Format( "{0}{1}", CommandSystem.Prefix, "Decorate" ) );
					CommandSystem.Handle( state.Mobile, String.Format( "{0}{1}", CommandSystem.Prefix, "Doorgen" ) );
					CommandSystem.Handle( state.Mobile, String.Format( "{0}{1}", CommandSystem.Prefix, "Telgen" ) );
					CommandSystem.Handle( state.Mobile, String.Format( "{0}{1}", CommandSystem.Prefix, "Signgen" ) );
					CommandSystem.Handle( state.Mobile, String.Format( "{0}{1}", CommandSystem.Prefix, "Moongen" ) );
					CommandSystem.Handle( state.Mobile, String.Format( "{0}{1}", CommandSystem.Prefix, "GenGauntlet" ) );
					CommandSystem.Handle( state.Mobile, String.Format( "{0}{1}", CommandSystem.Prefix, "SecretLocGen" ) );
					CommandSystem.Handle( state.Mobile, String.Format( "{0}{1}", CommandSystem.Prefix, "UOAMVendors" ) );
					CommandSystem.Handle( state.Mobile, String.Format( "{0}{1}", CommandSystem.Prefix, "Spawn" ) );

					state.Mobile.SendMessage( "Kurulum tamamland. Sunucunuz oynanmaya hazr." );
				}

				String yol = Path.Combine( Core.BaseDirectory, "Scripts/Hazirla.cs" );
				if ( File.Exists( yol ) )
					File.Delete( yol );
			}
		}
	}
}
