using System;
using Server;
using Server.Items;
using Server.Guilds;
using Server.Mobiles;
using Server.Gumps;

namespace Server.Misc
{
	public class Keywords
	{
		public static void Initialize()
		{
			// Register our speech handler
			EventSink.Speech += new SpeechEventHandler( EventSink_Speech );
		}

		public static void EventSink_Speech( SpeechEventArgs args )
		{
			Mobile from = args.Mobile;
			int[] keywords = args.Keywords;

			for ( int i = 0; i < keywords.Length; ++i )
			{
				switch ( keywords[i] )
				{
					case 0x002A: // *i resign from my guild*
					{
						if ( from.Guild != null )
							((Guild)from.Guild).RemoveMember( from );

						break;
					}
					case 0x0032: // *i must consider my sins*
					{
						from.CloseGump( typeof( TermGump ) );
						from.SendGump ( new TermGump( from ) );

						break;
					}
					case 0x0035: // i renounce my young player status*
					{
						if ( from is PlayerMobile && ((PlayerMobile)from).Young && !from.HasGump( typeof( RenounceYoungGump ) ) )
						{
							from.SendGump( new RenounceYoungGump() );
						}

						break;
					}
				}
			}
		}
		public class TermGump : Gump
		{
			public TermGump( Mobile from ) : base( 25, 25 )
			{
				Mobile m_from = from;
				string tera = m_from.Name;
				int terb = m_from.ShortTermMurders;
				int terc = m_from.Kills;
				int terd = m_from.Fame;
				int tere = m_from.Karma;
				PlayerMobile pm_from = (PlayerMobile)from;
				TimeSpan terf = pm_from.GameTime;
				TimeSpan terg = pm_from.KillDecreaseTime();
				int ter1 = Convert.ToInt32( terf.TotalDays );
				int ter2 = Convert.ToInt32( terg.TotalHours );

				this.Closable=true;
				this.Disposable=true;
				this.Dragable=true;
				this.Resizable=false;
				this.AddPage(0);
				this.AddBackground(50, 50, 276, 239, 3600);
				this.AddImage(0, 46, 10400);
				this.AddImage(294, 200, 10412);
				this.AddLabel(86, 75, 1160, tera);
				this.AddLabel(86, 116, 1149, @"Short Term Count");
				this.AddLabel(86, 132, 1149, @"Kills");
				this.AddLabel(86, 148, 1149, @"Fame");
				this.AddLabel(86, 164, 1149, @"Karma");
				this.AddLabel(86, 180, 1149, @"Online Time");
				this.AddLabel(86, 196, 1149, @"Kill Dme Sresi");
				this.AddLabel(210, 116, 1149, @": " + terb.ToString() );
				this.AddLabel(210, 132, 1149, @": " + terc.ToString() );
				this.AddLabel(210, 148, 1149, @": " + terd.ToString() );
				this.AddLabel(210, 164, 1149, @": " + tere.ToString() );
				this.AddLabel(210, 180, 1149, @": " + ter1.ToString() + " gn" );
				this.AddLabel(210, 196, 1149, @": " + ter2.ToString() + " saat" );
				this.AddButton(149, 238, 247, 248, 1, GumpButtonType.Reply, 0);
			}
		}
	}
}