using System;
using Server;
using Server.Mobiles;

namespace Server.Misc
{
	public class SkillCheck
	{
		private static readonly bool AntiMacroCode = true; //Change this to false to disable anti-macro code

		public static TimeSpan AntiMacroExpire = TimeSpan.FromMinutes( 5.0 ); //How long do we remember targets/locations?
		public const int Allowance = 3;	//How many times may we use the same location/target for gain
		private const int LocationSize = 5; //The size of eeach location, make this smaller so players dont have to move as far
		private static bool[] UseAntiMacro = new bool[]
		{
			// true if this skill uses the anti-macro code, false if it does not
			false,// Alchemy = 0,
			true,// Anatomy = 1,
			true,// AnimalLore = 2,
			true,// ItemID = 3,
			true,// ArmsLore = 4,
			false,// Parry = 5,
			true,// Begging = 6,
			false,// Blacksmith = 7,
			false,// Fletching = 8,
			true,// Peacemaking = 9,
			true,// Camping = 10,
			false,// Carpentry = 11,
			false,// Cartography = 12,
			false,// Cooking = 13,
			true,// DetectHidden = 14,
			true,// Discordance = 15,
			true,// EvalInt = 16,
			true,// Healing = 17,
			true,// Fishing = 18,
			true,// Forensics = 19,
			true,// Herding = 20,
			true,// Hiding = 21,
			true,// Provocation = 22,
			false,// Inscribe = 23,
			true,// Lockpicking = 24,
			true,// Magery = 25,
			true,// MagicResist = 26,
			false,// Tactics = 27,
			true,// Snooping = 28,
			true,// Musicianship = 29,
			true,// Poisoning = 30,
			false,// Archery = 31,
			true,// SpiritSpeak = 32,
			true,// Stealing = 33,
			false,// Tailoring = 34,
			true,// AnimalTaming = 35,
			true,// TasteID = 36,
			false,// Tinkering = 37,
			true,// Tracking = 38,
			true,// Veterinary = 39,
			false,// Swords = 40,
			false,// Macing = 41,
			false,// Fencing = 42,
			false,// Wrestling = 43,
			true,// Lumberjacking = 44,
			true,// Mining = 45,
			true,// Meditation = 46,
			true,// Stealth = 47,
			true,// RemoveTrap = 48,
			true,// Necromancy = 49,
			false,// Focus = 50,
			true,// Chivalry = 51
			true,// Bushido = 52
			true,//Ninjitsu = 53
			true // Spellweaving
		};

		public static void Initialize()
		{
			Mobile.SkillCheckLocationHandler = new SkillCheckLocationHandler( Mobile_SkillCheckLocation );
			Mobile.SkillCheckDirectLocationHandler = new SkillCheckDirectLocationHandler( Mobile_SkillCheckDirectLocation );

			Mobile.SkillCheckTargetHandler = new SkillCheckTargetHandler( Mobile_SkillCheckTarget );
			Mobile.SkillCheckDirectTargetHandler = new SkillCheckDirectTargetHandler( Mobile_SkillCheckDirectTarget );

			// u anda skill alm hz 50% dir. Bu durumu aadan deitirebilirsin:
			SkillInfo.Table[0].GainFactor = 1.00;// Alchemy = 0, 
			SkillInfo.Table[1].GainFactor = 1.00;// Anatomy = 1, 
			SkillInfo.Table[2].GainFactor = 1.00;// AnimalLore = 2, 
			SkillInfo.Table[3].GainFactor = 1.00;// ItemID = 3, 
			SkillInfo.Table[4].GainFactor = 1.00;// ArmsLore = 4, 
			SkillInfo.Table[5].GainFactor = 1.00;// Parry = 5, 
			SkillInfo.Table[6].GainFactor = 1.00;// Begging = 6, 
			SkillInfo.Table[7].GainFactor = 1.00;// Blacksmith = 7,
			SkillInfo.Table[8].GainFactor = 1.00;// Fletching = 8, 
			SkillInfo.Table[9].GainFactor = 1.00;// Peacemaking = 9, 
			SkillInfo.Table[10].GainFactor = 1.00;// Camping = 10, 
			SkillInfo.Table[11].GainFactor = 1.00;// Carpentry = 11, 
			SkillInfo.Table[12].GainFactor = 1.00;// Cartography = 12, 
			SkillInfo.Table[13].GainFactor = 1.00;// Cooking = 13, 
			SkillInfo.Table[14].GainFactor = 1.00;// DetectHidden = 14, 
			SkillInfo.Table[15].GainFactor = 1.00;// Discordance = 15, 
			SkillInfo.Table[16].GainFactor = 1.00;// EvalInt = 16, 
			SkillInfo.Table[17].GainFactor = 1.00;// Healing = 17, 
			SkillInfo.Table[18].GainFactor = 1.00;// Fishing = 18, 
			SkillInfo.Table[19].GainFactor = 1.00;// Forensics = 19,
			SkillInfo.Table[20].GainFactor = 1.00;// Herding = 20,
			SkillInfo.Table[21].GainFactor = 1.00;// Hiding = 21,
			SkillInfo.Table[22].GainFactor = 1.00;// Provocation = 22,
			SkillInfo.Table[23].GainFactor = 1.00;// Inscribe = 23,
			SkillInfo.Table[24].GainFactor = 1.00;// Lockpicking = 24,
			SkillInfo.Table[25].GainFactor = 1.00;// Magery = 25,
			SkillInfo.Table[26].GainFactor = 1.00;// MagicResist = 26,
			SkillInfo.Table[27].GainFactor = 1.00;// Tactics = 27,
			SkillInfo.Table[28].GainFactor = 1.00;// Snooping = 28,
			SkillInfo.Table[29].GainFactor = 1.00;// Musicianship = 29,
			SkillInfo.Table[30].GainFactor = 1.00;// Poisoning = 30
			SkillInfo.Table[31].GainFactor = 1.00;// Archery = 31 
			SkillInfo.Table[32].GainFactor = 1.00;// SpiritSpeak = 32 
			SkillInfo.Table[33].GainFactor = 1.00;// Stealing = 33
			SkillInfo.Table[34].GainFactor = 1.00;// Tailoring = 34
			SkillInfo.Table[35].GainFactor = 1.00;// AnimalTaming = 35
			SkillInfo.Table[36].GainFactor = 1.00;// TasteID = 36 
			SkillInfo.Table[37].GainFactor = 1.00;// Tinkering = 37
			SkillInfo.Table[38].GainFactor = 1.00;// Tracking = 38 
			SkillInfo.Table[39].GainFactor = 1.00;// Veterinary = 39 
			SkillInfo.Table[40].GainFactor = 1.00;// Swords = 40 
			SkillInfo.Table[41].GainFactor = 1.00;// Macing = 41 
			SkillInfo.Table[42].GainFactor = 1.00;// Fencing = 42 
			SkillInfo.Table[43].GainFactor = 1.00;// Wrestling = 43 
			SkillInfo.Table[44].GainFactor = 1.00;// Lumberjacking = 44 
			SkillInfo.Table[45].GainFactor = 1.00;// Mining = 45 
			SkillInfo.Table[46].GainFactor = 1.00;// Meditation = 46 
			SkillInfo.Table[47].GainFactor = 1.00;// Stealth = 47 
			SkillInfo.Table[48].GainFactor = 1.00;// RemoveTrap = 48 
			SkillInfo.Table[49].GainFactor = 1.00;// Necromancy = 49 
			SkillInfo.Table[50].GainFactor = 1.00;// Focus = 50 
			SkillInfo.Table[51].GainFactor = 1.00;// Chivalry = 51
			SkillInfo.Table[52].GainFactor = 1.00;// Bushido = 52
			SkillInfo.Table[53].GainFactor = 1.00;// Ninjitsu = 53
		}

		public static bool Mobile_SkillCheckLocation( Mobile from, SkillName skillName, double minSkill, double maxSkill )
		{
			Skill skill = from.Skills[skillName];

			if ( skill == null )
				return false;

			double value = skill.Value;

			if ( value < minSkill )
				return false; // Too difficult
			else if ( value >= maxSkill )
				return true; // No challenge

			double chance = (value - minSkill) / (maxSkill - minSkill);

			Point2D loc = new Point2D( from.Location.X / LocationSize, from.Location.Y / LocationSize );
			return CheckSkill( from, skill, loc, chance );
		}

		public static bool Mobile_SkillCheckDirectLocation( Mobile from, SkillName skillName, double chance )
		{
			Skill skill = from.Skills[skillName];

			if ( skill == null )
				return false;

			if ( chance < 0.0 )
				return false; // Too difficult
			else if ( chance >= 1.0 )
				return true; // No challenge

			Point2D loc = new Point2D( from.Location.X / LocationSize, from.Location.Y / LocationSize );
			return CheckSkill( from, skill, loc, chance );
		}

		public static bool CheckSkill( Mobile from, Skill skill, object amObj, double chance )
		{
			if ( from.Skills.Cap == 0 )
				return false;

			bool success = ( chance >= Utility.RandomDouble() );
			double BaseSkillGain = skill.Info.GainFactor;
			double ComputedSkillMod = 1.00;

			if ( skill.Base > 100.0 )
				ComputedSkillMod = BaseSkillGain - 1.00;
			else
				ComputedSkillMod = skill.Info.GainFactor;

			if ( skill.Base < 50.0 )
				ComputedSkillMod = 1.00;
			if ( ComputedSkillMod < 0.25 ) 
				ComputedSkillMod = 0.25;

			if ( from is BaseCreature && ((BaseCreature)from).Controlled )
				ComputedSkillMod *= 2;
			if ( from.Alive && ( ( ComputedSkillMod >= Utility.RandomDouble() && AllowGain( from, skill, amObj ) ) || skill.Base < 10.0 ) )
				Gain( from, skill );

			return success;
		}

		public static bool Mobile_SkillCheckTarget( Mobile from, SkillName skillName, object target, double minSkill, double maxSkill )
		{
			Skill skill = from.Skills[skillName];

			if ( skill == null )
				return false;

			double value = skill.Value;

			if ( value < minSkill )
				return false; // Too difficult
			else if ( value >= maxSkill )
				return true; // No challenge

			double chance = (value - minSkill) / (maxSkill - minSkill);

			return CheckSkill( from, skill, target, chance );
		}

		public static bool Mobile_SkillCheckDirectTarget( Mobile from, SkillName skillName, object target, double chance )
		{
			Skill skill = from.Skills[skillName];

			if ( skill == null )
				return false;

			if ( chance < 0.0 )
				return false; // Too difficult
			else if ( chance >= 1.0 )
				return true; // No challenge

			return CheckSkill( from, skill, target, chance );
		}

		private static bool AllowGain( Mobile from, Skill skill, object obj )
		{
			if ( AntiMacroCode && from is PlayerMobile && UseAntiMacro[skill.Info.SkillID] )
				return ((PlayerMobile)from).AntiMacroCheck( skill, obj );
			else
				return true;
		}

		public enum Stat { Str, Dex, Int }

		public static void Gain( Mobile from, Skill skill )
		{
			if ( from.Region.IsPartOf( typeof( Regions.Jail ) ) )
				return;

			if ( from is BaseCreature && ((BaseCreature)from).IsDeadPet )
				return;

			if ( skill.SkillName == SkillName.Focus && from is BaseCreature )
				return;

			if ( skill.Base < skill.Cap && skill.Lock == SkillLock.Up )
			{
				int toGain = 1;

				if ( skill.Base <= 10.0 )
					toGain = Utility.Random( 4 ) + 1;

				Skills skills = from.Skills;

				if ( from.Player && ( skills.Total / skills.Cap ) >= Utility.RandomDouble() )//( skills.Total >= skills.Cap )
				{
					for ( int i = 0; i < skills.Length; ++i )
					{
						Skill toLower = skills[i];

						if ( toLower != skill && toLower.Lock == SkillLock.Down && toLower.BaseFixedPoint >= toGain )
						{
							toLower.BaseFixedPoint -= toGain;
							break;
						}
					}
				}

				if ( !from.Player || (skills.Total + toGain) <= skills.Cap )
				{
					skill.BaseFixedPoint += toGain;
				}
			}

			if ( skill.Lock == SkillLock.Up )
			{
				SkillInfo info = skill.Info;

				if ( from.StrLock == StatLockType.Up && (info.StrGain / 33.3) > Utility.RandomDouble() )
					GainStat( from, Stat.Str );
				else if ( from.DexLock == StatLockType.Up && (info.DexGain / 33.3) > Utility.RandomDouble() )
					GainStat( from, Stat.Dex );
				else if ( from.IntLock == StatLockType.Up && (info.IntGain / 33.3) > Utility.RandomDouble() )
					GainStat( from, Stat.Int );
			}
		}

		public static bool CanLower( Mobile from, Stat stat )
		{
			switch ( stat )
			{
				case Stat.Str: return ( from.StrLock == StatLockType.Down && from.RawStr > 10 );
				case Stat.Dex: return ( from.DexLock == StatLockType.Down && from.RawDex > 10 );
				case Stat.Int: return ( from.IntLock == StatLockType.Down && from.RawInt > 10 );
			}

			return false;
		}

		public static bool CanRaise( Mobile from, Stat stat )
		{
			if ( from is PlayerMobile )
			{
				if ( from.RawStatTotal >= from.StatCap )
					return false;
				else
				{
					switch ( stat )
					{
						case Stat.Str: return ( from.StrLock == StatLockType.Up && from.RawStr < 125 );
						case Stat.Dex: return ( from.DexLock == StatLockType.Up && from.RawDex < 125 );
						case Stat.Int: return ( from.IntLock == StatLockType.Up && from.RawInt < 125 );
					}
				}
			}
			else if ( from is BaseCreature && ((BaseCreature)from).Controlled )
			{
				if ( from is WhiteWyrm )
				{
					switch ( stat )
					{
						case Stat.Str: return ( from.StrLock == StatLockType.Up && from.RawStr < 800 );
						case Stat.Dex: return ( from.DexLock == StatLockType.Up && from.RawDex < 130 );
						case Stat.Int: return ( from.IntLock == StatLockType.Up && from.RawInt < 500 );
					}
				}
				if ( from is Dragon )
				{
					switch ( stat )
					{
						case Stat.Str: return ( from.StrLock == StatLockType.Up && from.RawStr < 850 );
						case Stat.Dex: return ( from.DexLock == StatLockType.Up && from.RawDex < 110 );
						case Stat.Int: return ( from.IntLock == StatLockType.Up && from.RawInt < 500 );
					}
				}
				if ( from is Nightmare )
				{
					switch ( stat )
					{
						case Stat.Str: return ( from.StrLock == StatLockType.Up && from.RawStr < 550 );
						case Stat.Dex: return ( from.DexLock == StatLockType.Up && from.RawDex < 110 );
						case Stat.Int: return ( from.IntLock == StatLockType.Up && from.RawInt < 130 );
					}
				}
				if ( from is FireSteed )
				{
					switch ( stat )
					{
						case Stat.Str: return ( from.StrLock == StatLockType.Up && from.RawStr < 400 );
						case Stat.Dex: return ( from.DexLock == StatLockType.Up && from.RawDex < 120 );
						case Stat.Int: return ( from.IntLock == StatLockType.Up && from.RawInt < 300 );
					}
				}
				if ( from is Unicorn )
				{
					switch ( stat )
					{
						case Stat.Str: return ( from.StrLock == StatLockType.Up && from.RawStr < 325 );
						case Stat.Dex: return ( from.DexLock == StatLockType.Up && from.RawDex < 115 );
						case Stat.Int: return ( from.IntLock == StatLockType.Up && from.RawInt < 225 );
					}
				}
				if ( from is Kirin )
				{
					switch ( stat )
					{
						case Stat.Str: return ( from.StrLock == StatLockType.Up && from.RawStr < 325 );
						case Stat.Dex: return ( from.DexLock == StatLockType.Up && from.RawDex < 105 );
						case Stat.Int: return ( from.IntLock == StatLockType.Up && from.RawInt < 225 );
					}
				}
			}
			
			return false;
		}

		public static void IncreaseStat( Mobile from, Stat stat, bool atrophy )
		{
			atrophy = atrophy || (from.RawStatTotal >= from.StatCap);

			switch ( stat )
			{
				case Stat.Str:
				{
					if ( atrophy )
					{
						if ( CanLower( from, Stat.Dex ) && (from.RawDex < from.RawInt || !CanLower( from, Stat.Int )) )
							--from.RawDex;
						else if ( CanLower( from, Stat.Int ) )
							--from.RawInt;
					}

					if ( CanRaise( from, Stat.Str ) )
						++from.RawStr;

					break;
				}
				case Stat.Dex:
				{
					if ( atrophy )
					{
						if ( CanLower( from, Stat.Str ) && (from.RawStr < from.RawInt || !CanLower( from, Stat.Int )) )
							--from.RawStr;
						else if ( CanLower( from, Stat.Int ) )
							--from.RawInt;
					}

					if ( CanRaise( from, Stat.Dex ) )
						++from.RawDex;

					break;
				}
				case Stat.Int:
				{
					if ( atrophy )
					{
						if ( CanLower( from, Stat.Str ) && (from.RawStr < from.RawDex || !CanLower( from, Stat.Dex )) )
							--from.RawStr;
						else if ( CanLower( from, Stat.Dex ) )
							--from.RawDex;
					}

					if ( CanRaise( from, Stat.Int ) )
						++from.RawInt;

					break;
				}
			}
		}

		private static TimeSpan m_StatGainDelay = TimeSpan.FromSeconds( 15.0 );

		public static void GainStat( Mobile from, Stat stat )
		{
			switch( stat )
			{
				case Stat.Str:
				{
					if( (from.LastStrGain + m_StatGainDelay) >= DateTime.Now )
						return;

					from.LastStrGain = DateTime.Now;
					break;
				}
				case Stat.Dex:
				{
					if( (from.LastDexGain + m_StatGainDelay) >= DateTime.Now )
						return;

					from.LastDexGain = DateTime.Now;
					break;
				}
				case Stat.Int:
				{
					if( (from.LastIntGain + m_StatGainDelay) >= DateTime.Now )
						return;

					from.LastIntGain = DateTime.Now;
					break;
				}
			}

			bool atrophy = ( (from.RawStatTotal / (double)from.StatCap) >= Utility.RandomDouble() );

			IncreaseStat( from, stat, atrophy );
		}
	}
}