// RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

using System;
using System.Xml;
using Server;
using Server.Commands;
using Server.Mobiles;
using Server.Spells;
using Server.Spells.Chivalry;
using Server.Spells.Third;
using Server.Spells.Fourth;
using Server.Spells.Fifth;
using Server.Spells.Sixth;
using Server.Spells.Seventh;
using Server.Spells.Eighth;
using Server.Spells.Necromancy;

namespace Server.Regions
{
	public class SafeZone : BaseRegion
	{
		private bool m_Disabled;

		public bool Disabled{ get{ return m_Disabled; } set{ m_Disabled = value; } }

		public SafeZone( XmlElement xml, Map map, Region parent ) : base( xml, map, parent )
		{
		}
		public static void Initialize()
		{
			CommandSystem.Register( "SafeZone", AccessLevel.GameMaster, new CommandEventHandler( SafeZoneCommand ) );
		}
		public virtual bool IsDisabled()
		{
			return m_Disabled;
		}

		[Usage( "SafeZone" )]
		private static void SafeZoneCommand( CommandEventArgs e )
		{
			Mobile from = e.Mobile;
			SafeZone reg = from.Region as SafeZone;
			if ( reg == null )
			{
				from.SendMessage("Gvenli alan olabilecek bir blgede deilsiniz...");
				return;
			}
			else if ( reg != null && reg.Disabled )
				from.SendMessage("Safe Zone alan etkinletirilmitir...");
			else if ( reg != null && !reg.Disabled )
				from.SendMessage("Blge gvenli alandan karlmtr..");
			reg.Disabled = !reg.Disabled;
		}
		public static SafeZone Disable( SafeZone reg )
		{
			reg.Disabled = true;
			return reg;
		}
		public override bool AllowBeneficial( Mobile from, Mobile target )
		{
			if ( IsDisabled() )
				return true;

			if ( target.Criminal || target.Kills > 4 )
				return false;
			return true;
		}
		public override bool AllowHarmful( Mobile from, Mobile target )
		{
			if ( IsDisabled() )
				return true;

			if ( from is PlayerMobile && IsSummoned( target ) )
				return false;
			if ( IsSummoned( from ) && target is PlayerMobile )
				return false;
			if ( from is PlayerMobile && IsMonster( target ) )
				return true;
			if ( IsMonster( from ) && target is PlayerMobile )
				return true;
			if ( IsPet( from ) && IsMonster( target ) )
				return true;
			if ( IsMonster( from ) && IsPet( target ) )
				return true;
			return false;
		}
		private static bool IsMonster( Mobile m )
		{
			return ( m is BaseCreature && !((BaseCreature)m).Controlled );
		}
		private static bool IsPet( Mobile m )
		{
			return ( m is BaseCreature && ((BaseCreature)m).Controlled );
		}
		private static bool IsSummoned( Mobile m )
		{
			return ( m is BaseCreature && ((BaseCreature)m).Summoned && ((BaseCreature)m).SummonMaster != null );
		}
		public override void OnEnter( Mobile m )
		{
			if ( IsDisabled() )
				return;
			base.OnEnter( m );
		}
		public override void OnExit( Mobile m )
		{
			if ( IsDisabled() )
				return;
			base.OnExit( m );
		}
		public override bool OnBeginSpellCast( Mobile m, ISpell s )
		{
			if ( IsDisabled() )
				return true;
			if ( m.AccessLevel == AccessLevel.Player && ( s is BladeSpiritsSpell
				|| s is EnergyVortexSpell
				|| s is VengefulSpiritSpell
				|| s is FireElementalSpell
				|| s is EarthElementalSpell
				|| s is WaterElementalSpell
				|| s is SummonDaemonSpell
				|| s is AirElementalSpell
				|| s is FireFieldSpell
				|| s is ParalyzeFieldSpell
				|| s is DispelFieldSpell
				|| s is PoisonFieldSpell
				|| s is EnergyFieldSpell
				|| s is GateTravelSpell
				|| s is TeleportSpell
				|| s is SummonFamiliarSpell ) )
			{
				m.SendMessage( "Bu byy bu alanda kullanamazsn." );
				return false;
			}
			return base.OnBeginSpellCast( m, s );
		}
		public override TimeSpan GetLogoutDelay( Mobile m )
		{
			if ( IsDisabled() )
				return base.GetLogoutDelay( m );

			return TimeSpan.Zero;
		}
		public override void AlterLightLevel( Mobile m, ref int global, ref int personal )
		{
			global = 10;
		}
		public override bool AllowHousing( Mobile from, Point3D p )
		{
			return false;
		}
	}
}
