// RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

// [g <mesaj>, Guild yelerine mesaj gnderir.
// [ga <mesaj> ya da [ally <mesaj>, ttifak yelerine mesaj gnderir.
// [gx, guild mesaj almn aar ya da kapatr.

using System;
using System.Collections;
using Server; 
using Server.Items; 
using Server.Mobiles; 
using Server.Guilds;
using Server.Network;

namespace Server.Commands
{ 
	public class GuildChat
	{
		private static Hashtable ChatBan = new Hashtable();
		private static Hashtable IgnoreList = new Hashtable();

		private static string[] Mesaj = new string[]
				{
					"Bu komutu kullanabilmeniz iin herhangi bir guilde ye olmalsnz.",
					"Mesajnz 10 saniye sonra gnderin.",
					"Ileti alamaz ve gnderemezsiniz. Engeli kaldrmak iin [gx komutu kullann...",
					"Jailde iken Guild Chat'in kullanm yasaktr.",
					"Guild konumalarn kapattnz.",
					"Guild konumalarn atnz.",
				};

		public static void Initialize() 
		{
			CommandSystem.Register( "G", AccessLevel.Player, new CommandEventHandler( GuildCommand ) );
			CommandSystem.Register( "GA", AccessLevel.Player, new CommandEventHandler( GuildAllyCommand ) );
			CommandSystem.Register( "Ally", AccessLevel.Player, new CommandEventHandler( GuildAllyCommand ) );
			CommandSystem.Register( "GX", AccessLevel.Player, new CommandEventHandler( GuildIgnoreCommand ) );
		}
		[Usage( "g <message>" )]
		[Description( "Guild mesaj gnderir." )]
		private static void GuildCommand( CommandEventArgs e )
		{
			if ( e.Mobile.Guild == null )
				e.Mobile.SendMessage( Mesaj[0] );
			else if ( ChatBan[e.Mobile] != null && ((DateTime)ChatBan[e.Mobile]).AddSeconds( 10 ) > DateTime.Now && (e.Mobile).AccessLevel < AccessLevel.Counselor )
				(e.Mobile).SendMessage( Mesaj[1] );
			else if ( IgnoreList[e.Mobile] != null )
				e.Mobile.SendMessage( Mesaj[2] );
			else if ( e.Mobile.Region is Server.Regions.Jail )
				e.Mobile.SendMessage( Mesaj[3] );
			else
			{
				ChatBan[e.Mobile] = DateTime.Now;

				foreach ( Network.NetState state in Network.NetState.Instances )
				{
					if ( state.Mobile == null )
						continue;
					else if ( IgnoreList[state.Mobile] == null && state.Mobile.Guild == e.Mobile.Guild )
						state.Mobile.SendMessage( e.Mobile.SpeechHue, "[{0}] {1}", e.Mobile.Name, e.ArgString );
					else if ( state.Mobile.AccessLevel > AccessLevel.Seer )
						state.Mobile.SendMessage( e.Mobile.SpeechHue, "[{0}][{1}] {2}", e.Mobile.Guild.Abbreviation, e.Mobile.Name, e.ArgString );
				}
			}
		}
		[Usage( "ga <message>" )]
		[Description( "Guild mesaj gnderir." )]
		private static void GuildAllyCommand( CommandEventArgs e )
		{
			if ( e.Mobile.Guild == null )
				e.Mobile.SendMessage( Mesaj[0] );
			else if ( ChatBan[e.Mobile] != null && ((DateTime)ChatBan[e.Mobile]).AddSeconds( 10 ) > DateTime.Now && (e.Mobile).AccessLevel < AccessLevel.Counselor )
				(e.Mobile).SendMessage( Mesaj[1] );
			else if ( IgnoreList[e.Mobile] != null )
				e.Mobile.SendMessage( Mesaj[2] );
			else if ( e.Mobile.Region is Server.Regions.Jail )
				e.Mobile.SendMessage( Mesaj[3] );
			else
			{
				ChatBan[e.Mobile] = DateTime.Now;

				foreach ( Network.NetState state in Network.NetState.Instances )
				{
					if ( state.Mobile == null || ( state.Mobile != null && state.Mobile.Guild == null) )
						continue;
					else if ( IgnoreList[state.Mobile] == null && ( state.Mobile.Guild == e.Mobile.Guild || (e.Mobile.Guild as Guild).IsAlly( state.Mobile.Guild as Guild ) ) )
						state.Mobile.SendMessage( 68, "[{0}] {1}: {2}", e.Mobile.Guild.Abbreviation, e.Mobile.Name, e.ArgString );
					else if ( state.Mobile.AccessLevel > AccessLevel.Seer )
						state.Mobile.SendMessage( 68, "[{0}][{1}] {2}", e.Mobile.Guild.Abbreviation, e.Mobile.Name, e.ArgString );
				}
			}
		}
		[Usage( "GX" )]
		[Description( "Guild Chati kapatmak..." )]
		private static void GuildIgnoreCommand( CommandEventArgs e )
		{
			if ( IgnoreList[e.Mobile] == null )
			{
				e.Mobile.SendMessage( Mesaj[4] );
				IgnoreList[e.Mobile] = e.Mobile;
			}
			else
			{
				e.Mobile.SendMessage( Mesaj[5] );
				IgnoreList[e.Mobile] = null;
			}
		}
	}
}
