// RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

using System;
using Server; 
using Server.Items; 
using Server.Mobiles; 
using Server.Gumps;
using Server.Targeting;
using Server.Commands;

namespace Server.PlayerCommands
{ 
	public class PotList
	{
		public static void Initialize() 
		{
			CommandSystem.Register( "Pots", AccessLevel.Player, new CommandEventHandler( MurPots_OnCommand ) ); 
		}
		[Usage( "MurPots" )] 
		public static void MurPots_OnCommand( CommandEventArgs e ) 
		{
			e.Mobile.CloseGump( typeof( Mpots ) );
			e.Mobile.SendGump ( new Mpots( e.Mobile ) );
		}
	}
	public class Mpots : Gump
	{
		public static bool OldStyle = PropsConfig.OldStyle;

		public static readonly int GumpOffsetX = PropsConfig.GumpOffsetX;
		public static readonly int GumpOffsetY = PropsConfig.GumpOffsetY;

		public static readonly int TextHue = PropsConfig.TextHue;
		public static readonly int TextOffsetX = PropsConfig.TextOffsetX;

		public static readonly int OffsetGumpID = PropsConfig.OffsetGumpID;
		public static readonly int HeaderGumpID = PropsConfig.HeaderGumpID;
		public static readonly int  EntryGumpID = PropsConfig.EntryGumpID;
		public static readonly int   BackGumpID = PropsConfig.BackGumpID;
		public static readonly int    SetGumpID = PropsConfig.SetGumpID;

		public static readonly int SetWidth = PropsConfig.SetWidth;
		public static readonly int SetOffsetX = PropsConfig.SetOffsetX, SetOffsetY = PropsConfig.SetOffsetY;
		public static readonly int SetButtonID1 = PropsConfig.SetButtonID1;
		public static readonly int SetButtonID2 = PropsConfig.SetButtonID2;

		public static readonly int PrevWidth = PropsConfig.PrevWidth;
		public static readonly int PrevOffsetX = PropsConfig.PrevOffsetX, PrevOffsetY = PropsConfig.PrevOffsetY;
		public static readonly int PrevButtonID1 = PropsConfig.PrevButtonID1;
		public static readonly int PrevButtonID2 = PropsConfig.PrevButtonID2;

		public static readonly int NextWidth = PropsConfig.NextWidth;
		public static readonly int NextOffsetX = PropsConfig.NextOffsetX, NextOffsetY = PropsConfig.NextOffsetY;
		public static readonly int NextButtonID1 = PropsConfig.NextButtonID1;
		public static readonly int NextButtonID2 = PropsConfig.NextButtonID2;

		public static readonly int OffsetSize = PropsConfig.OffsetSize;

		public static readonly int EntryHeight = PropsConfig.EntryHeight;
		public static readonly int BorderSize = PropsConfig.BorderSize;

		private static bool PrevLabel = false, NextLabel = false;

		private static readonly int PrevLabelOffsetX = PrevWidth + 1;
		private static readonly int PrevLabelOffsetY = 0;

		private static readonly int NextLabelOffsetX = -29;
		private static readonly int NextLabelOffsetY = 0;

		private static readonly int EntryWidth = 180;
		private static readonly int EntryCount = 15;

		private static readonly int TotalWidth = OffsetSize + EntryWidth + OffsetSize + SetWidth + OffsetSize;
		private static readonly int TotalHeight = OffsetSize + ((EntryHeight + OffsetSize) * (EntryCount + 1));

		private static readonly int BackWidth = BorderSize + TotalWidth + BorderSize;
		private static readonly int BackHeight = BorderSize + TotalHeight + BorderSize;

		static int[] regs_amount = new int[16];
		static int[] regs_pic = new int[16];
		static string[] regs_name = new string[16];

		public Mpots( Mobile from) : base( GumpOffsetX, GumpOffsetY )
		{
			from.CloseGump( typeof( Mpots ) );
			Initialize( from );
		}

		public void Initialize( Mobile from )
		{
			Mobile m_from = from;
			Container bp = m_from.Backpack;
			regs_amount[0] = bp.GetAmount( typeof(AgilityPotion), true );
			regs_amount[1] = bp.GetAmount( typeof(GreaterAgilityPotion), true );
			regs_amount[2] = bp.GetAmount( typeof(CurePotion), true );
			regs_amount[3] = bp.GetAmount( typeof(LesserCurePotion), true );
			regs_amount[4] = bp.GetAmount( typeof(GreaterCurePotion), true );
			regs_amount[5] = bp.GetAmount( typeof(HealPotion), true );
			regs_amount[6] = bp.GetAmount( typeof(LesserHealPotion), true );
			regs_amount[7] = bp.GetAmount( typeof(GreaterHealPotion), true );
			regs_amount[8] = bp.GetAmount( typeof(RefreshPotion), true );
			regs_amount[9] = bp.GetAmount( typeof(TotalRefreshPotion), true );
			regs_amount[10] = bp.GetAmount( typeof(StrengthPotion), true );
			regs_amount[11] = bp.GetAmount( typeof(GreaterStrengthPotion), true );
			regs_amount[12] = bp.GetAmount( typeof(ExplosionPotion), true );
			regs_amount[13] = bp.GetAmount( typeof(LesserExplosionPotion), true );
			regs_amount[14] = bp.GetAmount( typeof(GreaterExplosionPotion), true );
			regs_amount[15] = bp.GetAmount( typeof(NightSightPotion), true );
			regs_name[0] = "Agility";
			regs_name[1] = "Greater Agility";
			regs_name[2] = "Cure";
			regs_name[3] = "Lesser Cure";
			regs_name[4] = "Greater Cure";
			regs_name[5] = "Heal";
			regs_name[6] = "Lesser Heal";
			regs_name[7] = "Greater Heal";
			regs_name[8] = "Refresh";
			regs_name[9] = "Total Refresh";
			regs_name[10] = "Strenght";
			regs_name[11] = "Greater Strenght";
			regs_name[12] = "Explosion";
			regs_name[13] = "Lesser Explosion";
			regs_name[14] = "Greater Explosion";
			regs_name[15] = "Night Sight";
			regs_pic[0] = 0xF08;
			regs_pic[1] = 0xF08;
			regs_pic[2] = 0xF07;
			regs_pic[3] = 0xF07;
			regs_pic[4] = 0xF07;
			regs_pic[5] = 0xF0C;
			regs_pic[6] = 0xF0C;
			regs_pic[7] = 0xF0C;
			regs_pic[8] = 0xF0B;
			regs_pic[9] = 0xF0B;
			regs_pic[10] = 0xF09;
			regs_pic[11] = 0xF09;
			regs_pic[12] = 0xF0D;
			regs_pic[13] = 0xF0D;
			regs_pic[14] = 0xF0D;
			regs_pic[15] = 0xF06;

			int count = 16;
			int totalHeight = OffsetSize + ((EntryHeight + OffsetSize) * (count + 1));
			AddPage( 0 );
			AddBackground( 0, 0, BackWidth, BorderSize + totalHeight + BorderSize, BackGumpID );
			AddImageTiled( BorderSize, BorderSize, TotalWidth - (OldStyle ? SetWidth + OffsetSize : 0), totalHeight, OffsetGumpID );
			int x = BorderSize + OffsetSize;
			int y = BorderSize + OffsetSize;

			int emptyWidth = TotalWidth - PrevWidth - NextWidth - (OffsetSize * 4) - (OldStyle ? SetWidth + OffsetSize : 0);
			if ( !OldStyle )
				AddImageTiled( x - (OldStyle ? OffsetSize : 0), y, emptyWidth + (OldStyle ? OffsetSize * 2 : 0), EntryHeight, EntryGumpID );

			AddLabel( x + TextOffsetX + 5, y + ((EntryHeight - 20) / 2), TextHue, "Potions List" );

			x += emptyWidth + OffsetSize;

			if ( OldStyle )
				AddImageTiled( x, y, TotalWidth - (OffsetSize * 3) - SetWidth, EntryHeight, HeaderGumpID );
			else
				AddImageTiled( x, y, PrevWidth, EntryHeight, HeaderGumpID );
			x += PrevWidth + OffsetSize;
			if ( !OldStyle )
				AddImageTiled( x, y, NextWidth, EntryHeight, HeaderGumpID );

			for ( int i = 0; i < count; ++i )
			{
				x = BorderSize + OffsetSize;
				y += EntryHeight + OffsetSize;
				AddImageTiled( x, y, EntryWidth, EntryHeight, EntryGumpID );
				AddLabelCropped( x + TextOffsetX + 40, y + ((EntryHeight - 20) / 2), EntryWidth - TextOffsetX, EntryHeight, TextHue, regs_name[i] );

				int ort = 0;
				if ( i < 2 || i > 11 )
					ort = 10;

				AddItem( x + TextOffsetX + ort - 10, y + ((EntryHeight - 20) / 2), regs_pic[i]);
				AddLabel( x + TextOffsetX + 154, y + ((EntryHeight - 20) / 2), TextHue, regs_amount[i].ToString() );

				x += EntryWidth + OffsetSize;

				if ( SetGumpID != 0 )
					AddImageTiled( x, y, SetWidth, EntryHeight, SetGumpID );
			}
		}
	}
}