// RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

using System;
using Server; 
using Server.Items; 
using Server.Mobiles; 
using Server.Gumps; 
using Server.Commands;

namespace Server.PlayerCommands
{ 
	public class RegList
	{
		public static void Initialize() 
		{
			CommandSystem.Register( "Regs", AccessLevel.Player, new CommandEventHandler( RegsCommand ) ); 
		}
		[Usage( "Regs" )] 
		public static void RegsCommand( CommandEventArgs e ) 
		{
			e.Mobile.CloseGump( typeof( RegsGump ) );
			e.Mobile.SendGump( new RegsGump( e.Mobile ) );
		}
		public class RegsGump : Gump
		{
			public RegsGump( Mobile from ) : base( 0, 0 )
			{
				Container bp = from.Backpack;
				AddPage(0);
				AddBackground(50, 50, 232, 406, 9200);
				AddBackground(54, 56, 224, 29, 9350);
				AddLabel(118, 60, 0, @"Reagent List");
				AddBackground(91, 90, 187, 25, 9350);
				AddBackground(91, 90, 187, 25, 9350);
				AddBackground(91, 115, 187, 25, 9350);
				AddBackground(91, 140, 187, 25, 9350);
				AddBackground(91, 165, 187, 25, 9350);
				AddBackground(91, 190, 187, 25, 9350);
				AddBackground(91, 215, 187, 25, 9350);
				AddBackground(91, 240, 187, 25, 9350);
				AddBackground(91, 265, 187, 25, 9350);
				AddBackground(91, 295, 187, 25, 9350);
				AddBackground(91, 320, 187, 25, 9350);
				AddBackground(91, 345, 187, 25, 9350);
				AddBackground(91, 370, 187, 25, 9350);
				AddBackground(91, 395, 187, 25, 9350);
				AddBackground(91, 425, 187, 25, 9350);
				AddItem(51, 99, 3962);
				AddItem(51, 120, 3963);
				AddItem(55, 146, 3972);
				AddItem(45, 170, 3973);
				AddItem(49, 195, 3974);
				AddItem(49, 218, 3976);
				AddItem(49, 246, 3980);
				AddItem(52, 269, 3981);
				AddItem(47, 295, 3978);
				AddItem(56, 323, 3982);
				AddItem(49, 346, 3965);
				AddItem(46, 378, 3983);
				AddItem(50, 398, 3960);
				AddItem(49, 429, 3617);
				AddLabel(97, 93, 0, "Black Pearl");
				AddLabel(97, 118, 0, "Blood Moss");
				AddLabel(97, 143, 0, "Garlic");
				AddLabel(97, 168, 0, "Ginseng");
				AddLabel(97, 193, 0, "Mandrake Root");
				AddLabel(97, 218, 0, "Nightshade");
				AddLabel(97, 243, 0, "Sulfurous Ash");
				AddLabel(97, 268, 0, "Spider Silk");
				AddLabel(97, 298, 0, "Pig Iron");
				AddLabel(97, 323, 0, "Nox Crystal");
				AddLabel(97, 348, 0, "Daemon Blood");
				AddLabel(97, 373, 0, "Grave Dust");
				AddLabel(97, 398, 0, "Bat Wing");
				AddLabel(97, 428, 0, "Bandage");
				AddLabel(240, 93, 0, bp.GetAmount( typeof(BlackPearl), true ).ToString() );
				AddLabel(240, 118, 0, bp.GetAmount( typeof(Bloodmoss), true ).ToString() );
				AddLabel(240, 143, 0, bp.GetAmount( typeof(Garlic), true ).ToString() );
				AddLabel(240, 168, 0, bp.GetAmount( typeof(Ginseng), true ).ToString() );
				AddLabel(240, 193, 0, bp.GetAmount( typeof(MandrakeRoot), true ).ToString() );
				AddLabel(240, 218, 0, bp.GetAmount( typeof(Nightshade), true ).ToString() );
				AddLabel(240, 243, 0, bp.GetAmount( typeof(SulfurousAsh), true ).ToString() );
				AddLabel(240, 268, 0, bp.GetAmount( typeof(SpidersSilk), true ).ToString() );
				AddLabel(240, 298, 0, bp.GetAmount( typeof(PigIron), true ).ToString() );
				AddLabel(240, 323, 0, bp.GetAmount( typeof(NoxCrystal), true ).ToString() );
				AddLabel(240, 348, 0, bp.GetAmount( typeof(DaemonBlood), true ).ToString() );
				AddLabel(240, 373, 0, bp.GetAmount( typeof(GraveDust), true ).ToString() );
				AddLabel(240, 398, 0, bp.GetAmount( typeof(BatWing), true ).ToString() );
				AddLabel(240, 428, 0, bp.GetAmount( typeof(Bandage), true ).ToString() );
			}
		}
	}
}