// RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

using System;
using System.Text;
using System.Collections;
using Server;
using Server.Mobiles;
using Server.Network;
using Server.Items;
using Server.Gumps;
using Server.Commands;
using Server.ContextMenus;

namespace Server.GuardSystem
{
	public class PinCode
	{
		private static Hashtable Sqlock = new Hashtable();

		public static void Initialize() 
		{ 
			CommandSystem.Register( "Pin", AccessLevel.Player, new CommandEventHandler( PinCommand ) );

			EventSink.Login += new LoginEventHandler( OnLogin );
			EventSink.Logout += new LogoutEventHandler( OnLogout );
		}

		[Usage( "Pin" )] 
		public static void PinCommand( CommandEventArgs e ) 
		{
			if ( !e.Mobile.Alive || e.Mobile.CantWalk )
				return;

			PlayerMobile from = e.Mobile as PlayerMobile;
			if ( from != null && from.PinCodeNum != 0 )
				from.SendGump( new VenusAdminGump() );
			else
				from.SendGump( new VenusGump() );
		}
		private static void Engelle( Mobile from )
		{
			from.Frozen = true;
			from.CantWalk = true;

			if ( !from.Squelched )
			{
				from.Squelched = true;
				Sqlock[from] = true;
			}

			foreach( Item item in from.Items )
				item.Movable = false;
			foreach( Item item in from.Backpack.Items )
				item.Movable = false;
		}
		public static void Devam( Mobile from )
		{
			from.Frozen = false;
			from.CantWalk = false;

			if ( Sqlock[from] != null )
				from.Squelched = false;

			foreach( Item item in from.Items )
			{
				if ( item != null && item.Layer != Layer.FacialHair && item.Layer != Layer.Hair && !(item is BankBox || item is Backpack) )
					item.Movable = true;
				else
					item.Movable = false;
			}

			foreach( Item item in from.Backpack.Items )
				item.Movable = true;

			((PlayerMobile)from).PinCodeDate = DateTime.Now;
		}
		private static void OnLogin( LoginEventArgs e )
		{
			PlayerMobile from = e.Mobile as PlayerMobile;

			if ( from == null )
				return;

			// 7 gn boyunca karaktere girilmezse pin kodu devre d kalr.
			if ( from.PinCodeNum != 0 && from.PinCodeDate.AddDays( 7 ) < DateTime.Now )
			{
				from.SendMessage(1161, "Pin kodunuz sfrlanmtr...");
				from.PinCodeNum = 0;
			}
			else if ( from.PinCodeNum != 0 )
			{
				Engelle( from );
				from.SendGump( new PinCodeGump( "" ) );
			}
		}
		public static void OnLogout( LogoutEventArgs e )
		{
			PlayerMobile from = e.Mobile as PlayerMobile;

			if ( from == null )
				return;

			if ( from.CantWalk )
				Devam( from );
		}

		public class PinCodeGump : Gump
		{
			private string code;
			private int hatalar;

			public PinCodeGump( string text ) : this( text, 0 )
			{
			}
			public PinCodeGump( string text, int hata ) : base(0, 0)
			{
				code = text;
				hatalar = hata;

				if ( code.Length > 8 )
					code = "";

				Closable=false;
				Disposable=false;
				Dragable=false;
				Resizable=false;

				AddPage(0);
				AddBackground(100, 100, 399, 260, 83);
				AddLabel(251, 116, 1160, "Pin Kodunu Girin");
				AddLabel(130, 145, 1149, "Bu karakter pin kodu korumas ile korunmaktadr.");
				AddLabel(130, 160, 1149, "Ltfen aaya pin kodunu yazn...");
				AddBackground(130, 210, 348, 30, 9350);
				AddLabel(130, 190, 1149, "Pin Numaras:");
				AddButton(186, 310, 247, 248, 11, GumpButtonType.Reply, 0);
				AddButton(349, 310, 242, 243, 0, GumpButtonType.Reply, 0);
				AddButton(130, 270, 4005, 4007, 1, GumpButtonType.Reply, 0);
				AddButton(165, 270, 4005, 4007, 2, GumpButtonType.Reply, 0);
				AddButton(200, 270, 4005, 4007, 3, GumpButtonType.Reply, 0);
				AddButton(235, 270, 4005, 4007, 4, GumpButtonType.Reply, 0);
				AddButton(270, 270, 4005, 4007, 5, GumpButtonType.Reply, 0);
				AddButton(305, 270, 4005, 4007, 6, GumpButtonType.Reply, 0);
				AddButton(340, 270, 4005, 4007, 7, GumpButtonType.Reply, 0);
				AddButton(375, 270, 4005, 4007, 8, GumpButtonType.Reply, 0);
				AddButton(410, 270, 4005, 4007, 9, GumpButtonType.Reply, 0);
				AddButton(445, 270, 4005, 4007, 10, GumpButtonType.Reply, 0);
				AddLabel(140, 245, 1149, "1");
				AddLabel(175, 245, 1149, "2");
				AddLabel(210, 245, 1149, "3");
				AddLabel(245, 245, 1149, "4");
				AddLabel(280, 245, 1149, "5");
				AddLabel(315, 245, 1149, "6");
				AddLabel(350, 245, 1149, "7");
				AddLabel(385, 245, 1149, "8");
				AddLabel(420, 245, 1149, "9");
				AddLabel(455, 245, 1149, "0");
				AddLabel(136, 216, 1149, ( "********" ).Substring( 0, code.Length ) );
			}
			public override void OnResponse( NetState state, RelayInfo info )
			{
				int btnOk = info.ButtonID;

				if ( btnOk == 0 )
					state.Dispose();

				else if ( btnOk > 0 && btnOk < 11 )
				{
					string text = btnOk.ToString();

					if ( text == "10" )
						text = "0";

					code = code + text;
					state.Mobile.SendGump( new PinCodeGump( code, hatalar ) );
				}
				else
				{
					PlayerMobile from = state.Mobile as PlayerMobile;
					if ( from != null )
					{
						int number = Utility.ToInt32( code );

						if ( from.PinCodeNum != number )
						{
							hatalar++;
							from.SendMessage(1150, String.Format( "Yanl girdiniz ({0}/3)...", hatalar ) );

							if ( hatalar >= 3 )
								state.Dispose();
							else
								from.SendGump( new PinCodeGump( "", hatalar ) );
						}
						else
						{
							from.SendMessage(1150, "Hogeldiniz...");

							PinCode.Devam( from );
						}
					}
				}
			}
		}

		public class VenusGump : Gump
		{
			public VenusGump() : base(0, 0)
			{
				String msg = "Bu sistem karakterinize her giri yaptnzda istenecek 2. bir ifre demek. Bu ifreyi klavyeden deil bizim klavyemizden yazacaksnz. Yalnz ifreyi unutursanz 1 hafta oyuna giremeyeceksiniz. Bu konuda hibir staff yardmc olmayacaktr. 1 hafta girmezseniz pin kodu deaktif olacaktr otomatik.<BR><BR>Eer kabul ediyorsan EVET, iptal etmek istiyorsan HAYIR demelisin.";

				Closable=true;
				Disposable=false;
				Dragable=false;
				Resizable=false;

				AddPage(0);
				AddBackground(50, 50, 224, 227, 9350);
				AddLabel(60, 60, 98, "Pin Kodu Sistemi Yardmcs");
				AddImageTiled(50, 84, 221, 1, 2702);
				AddImageTiled(51, 230, 221, 1, 2702);
				AddImageTiled(50, 253, 221, 1, 2702);
				AddHtml( 62, 95, 200, 127, msg, true, true);
				AddButton(51, 231, 4005, 4007, 1, GumpButtonType.Reply, 0);
				AddButton(51, 254, 4005, 4007, 0, GumpButtonType.Reply, 0);
				AddLabel(90, 232, 0, "Evet");
				AddLabel(90, 254, 0, "Hayr");
			}
			public override void OnResponse( NetState state, RelayInfo info )
			{
				if ( info.ButtonID == 1 )
					state.Mobile.SendGump( new VenusSelectGump( state.Mobile ) );
			}
		}

		public class VenusSelectGump : Gump
		{
			public VenusSelectGump( Mobile from ) : base(0, 0)
			{
				String msg = "Pin kodunu kendin mi belirlemek istersin? yoksa bizim tarafmzdan kark olarak seilsin ve sana gsterilsin mi?";

				Closable=true;
				Disposable=false;
				Dragable=false;
				Resizable=false;

				AddPage(0);
				AddBackground(50, 50, 224, 227, 9350);
				AddLabel(60, 60, 98, "Pin Kodu Sistemi Yardmcs");
				AddImageTiled(50, 84, 221, 1, 2702);
				AddImageTiled(51, 230, 221, 1, 2702);
				AddImageTiled(50, 253, 221, 1, 2702);
				AddHtml( 62, 95, 200, 127, msg, true, true);
				AddButton(51, 231, 4005, 4007, 1, GumpButtonType.Reply, 0);
				AddButton(51, 254, 4005, 4007, 2, GumpButtonType.Reply, 0);
				AddLabel(90, 232, 0, "Kendim Belirleyeceim");
				AddLabel(90, 254, 0, "Sen Benim Yerime Belirle");
			}
			public override void OnResponse( NetState state, RelayInfo info )
			{
				if ( info.ButtonID == 1 )
					state.Mobile.SendGump( new VenusCodeSelectGump( state.Mobile ) );
				if ( info.ButtonID == 2 )
					state.Mobile.SendGump( new VenusCodeGump( state.Mobile ) );
			}
		}
		public class VenusCodeSelectGump : Gump
		{
			public VenusCodeSelectGump( Mobile mobile ) : base(0, 0)
			{
				Closable=false;
				Disposable=false;
				Dragable=false;
				Resizable=false;

				PlayerMobile from = mobile as PlayerMobile;
				AddPage(0);
				AddBackground(50, 50, 224, 227, 9350);
				AddLabel(60, 60, 1149, @"Pin Kodu Sistemi Yardmcs");
				AddImageTiled(50, 84, 221, 1, 2702);
				AddImageTiled(51, 230, 221, 1, 2702);
				AddImageTiled(50, 253, 221, 1, 2702);
				AddButton(51, 231, 4005, 4007, 1, GumpButtonType.Reply, 0);
				AddButton(51, 254, 4005, 4007, 0, GumpButtonType.Reply, 0);
				AddLabel(90, 232, 0, @"Tamam");
				AddLabel(90, 254, 0, @"Iptal");
				AddBackground(57, 115, 136, 30, 9350);
				AddLabel(60, 95, 0, @"Pin Kodunuz:");
				AddLabel(60, 150, 0, @"- 8 haneli olmak zorundadr.");
				AddLabel(60, 165, 0, @"- Sadece saylardan oluabilir.");
				AddLabel(60, 180, 0, @"- Unutmayn.");
				AddLabel(60, 195, 0, @"- Kimseye gstermeyin.");
				AddTextEntry(62, 120, 126, 20, 0, 0, "");
			}
			public override void OnResponse( NetState state, RelayInfo info )
			{
				try{
					PlayerMobile from = state.Mobile as PlayerMobile;
					if ( info.ButtonID == 1 )
					{
						String kod = ( info.GetTextEntry( 0 ) ).Text;
						if ( kod == null || kod == "" || kod.Length != 8 || Utility.ToInt32( kod ) == 0 )
							return;

						from.PinCodeNum = Utility.ToInt32( kod );
						from.SendMessage(1161, "Pin kodun ayarlanmtr.");
						from.PinCodeDate = DateTime.Now;
					}
					else
						from.SendMessage(1161, "Pin kodu belirlenmedi.");
				}
				catch{
				}
			}
		}
		public class VenusCodeGump : Gump
		{
			public VenusCodeGump( Mobile mobile ) : base(0, 0)
			{
				Closable=false;
				Disposable=false;
				Dragable=false;
				Resizable=false;

				PlayerMobile from = mobile as PlayerMobile;
				int number = Utility.RandomMinMax( 10000000, 99999999 );
				from.PinCodeDate = DateTime.Now;
				from.PinCodeNum = number;
				AddPage(0);
				AddBackground(50, 50, 342, 210, 83);
				AddBackground(72, 117, 300, 31, 9350);
				AddLabel(156, 61, 1160, @"Pin Kodu Uygulamas");
				AddLabel(74, 94, 1149, @"Yeni Pin Kodunuz:");
				AddLabel(78, 123, 0, number.ToString() );
				AddLabel(73, 160, 1149, @"Kimseye gstermeyin ve unutmayn!");
				AddLabel(73, 175, 1149, @"Bu kodu her login olduunuzda yazacaksnz.");
				AddLabel(73, 190, 1149, @"Eer unutursanz Staff yardm etmeyecektir.");
				AddButton(193, 217, 247, 248, 0, GumpButtonType.Reply, 0);
				from.SendMessage(1161, "Pin kodunuz ayarlanmtr.");
			}
		}
		public class VenusAdminGump : Gump
		{
			public VenusAdminGump() : base(0, 0)
			{
				Closable=true;
				Disposable=false;
				Dragable=false;
				Resizable=false;

				AddPage(0);
				AddBackground(50, 50, 228, 181, 83);
				AddLabel(75, 65, 1160, "Pin Kodu Sistemi");
				AddLabel(75, 90, 1149, "Ne Yapmak Istiyorsun?");
				AddButton(75, 120, 4005, 4007, 1, GumpButtonType.Reply, 0);
				AddButton(75, 149, 4005, 4007, 2, GumpButtonType.Reply, 0);
				AddButton(133, 184, 242, 243, 0, GumpButtonType.Reply, 0);
				AddLabel(110, 120, 1149, "Pin Kodunu Deitir");
				AddLabel(110, 150, 1149, "Pin Kodunu Iptal Et");
			}
			public override void OnResponse( NetState state, RelayInfo info )
			{
				if ( info.ButtonID == 0 )
					return;
				PlayerMobile from = state.Mobile as PlayerMobile;
				if ( info.ButtonID == 1 )
				{
					from.SendGump( new VenusSelectGump( from ) );
					return;
				}
				if ( info.ButtonID == 2 )
				{
					from.PinCodeNum = 0;
					from.SendMessage(1161, "Artk karakterin pin kodu ile korunmuyor! Pin kodu sfrlanmtr.");
				}
			}
		}
	}
}
