// RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

using System;
using Server;
using Server.Commands;
using Server.Network;
using Server.Gumps;
using Server.Mobiles;

namespace Server.Misc
{
	public class PlayerStatus
	{
		public static void Initialize()
		{
			EventSink.Login += new LoginEventHandler( OnLogin );
		}

		private static void OnLogin( LoginEventArgs e )
		{
			if ( e.Mobile.Name == "IsimBulPageAt" || e.Mobile.Name.IndexOf("IsimBulPageAt") > -1 )
				e.Mobile.SendGump( new NameGump() );

			int userCount = NetState.Instances.Count;
			int itemCount = World.Items.Count;
			int mobileCount = World.Mobiles.Count;

			e.Mobile.SendMessage( String.Format("Merhaba, {0}. Hogeldin! u anda {1} oyuncu online. Ayrca {2} hareketsiz ve {3} hareketli nesne bulunmakta.", e.Mobile.Name, userCount, itemCount, mobileCount ) );
		}
		public class NameGump : Gump
		{
			public NameGump() : base(0, 0)
			{
				Closable=true;
				Disposable=true;
				Dragable=true;
				Resizable=false;
				AddPage(0);
				AddBackground(50, 50, 322, 202, 9200);
				AddLabel(157, 61, 1160, "Isim Deiiklii");
				AddHtml( 64, 89, 291, 57, "     Kullandnz isim sunucumuzda bulunmaktadr ya da kullanm yasaktr. Ltfen yeni bir tane seiniz:", false, false);
				AddLabel(65, 174, 0, "Yeni Isim:");
				AddBackground(131, 170, 221, 30, 9350);
				AddTextEntry(138, 174, 207, 23, 0, 0, "");
				AddButton(140, 216, 247, 248, 1, GumpButtonType.Reply, 0);
				AddButton(220, 215, 241, 243, 0, GumpButtonType.Reply, 0);
			}
			public override void OnResponse( NetState state, RelayInfo info )
			{
				if ( info.ButtonID == 0 || state.Mobile == null )
					return;

				try{
					String Yeni = ( info.GetTextEntry( 0 ) ).Text;
					if ( Yeni.Length < 3 )
						return;
	
					if ( !NameVerification.Validate( Yeni, 2, 16, true, true, true, 1, NameVerification.SpaceDashPeriodQuote ) && state.Mobile != null )
						state.Mobile.SendGump( new NameGump() );
					else if ( !CheckName( state.Mobile, Yeni ) )
						state.Mobile.SendGump( new NameGump() );
					else
					{
						if ( state.Mobile != null )
							state.Mobile.Name = Yeni;
					}
				}
				catch{
				}
			}
		}
		public static bool CheckName( Mobile from, String name )
		{
			foreach ( Mobile m in World.Mobiles.Values )
			{
				if ( m != null && m is PlayerMobile && m.Name.ToLower() == name.ToLower() )
					return false;
			}
			return true;
		}
	}
}