// RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

// Bodcu karakterlerin bod haklarn tek bir karakterde toplar ve bu karakter
// yoluyla toplanmasn salar. Ayrca kontrat haline getirilip satlabilir.

using System;
using System.Collections;
using Server; 
using Server.Items; 
using Server.Mobiles; 
using Server.Targeting; 
using Server.Network;
using Server.Gumps;
using Server.Commands;

namespace Server.BODSystem
{ 
	public class Core
	{
		private static Hashtable ScrollLimit = new Hashtable();

		public static void Initialize() 
		{
			if ( Ayarlar.BodcuSistemi )
			{
				CommandSystem.Register( "Bod", AccessLevel.Player, new CommandEventHandler( BodCommand ) );
				CommandSystem.Register( "Bodcu", AccessLevel.Player, new CommandEventHandler( BodcuCommand ) );
			}
		}
		[Usage( "Bod" )] 
		public static void BodCommand( CommandEventArgs e ) 
		{
			e.Mobile.CloseGump( typeof ( BODGump ) );
			e.Mobile.SendGump( new BODGump( e.Mobile ) );
		}
		public class BODGump : Gump
		{
			public BODGump( Mobile from ) : base(0, 0)
			{
				PlayerMobile pm = (PlayerMobile)from;

				AddPage(0);
				AddBackground(50, 50, 283, 277, 9270);
				AddImageTiled(61, 61, 261, 255, 2624);
				AddItem(71, 66, 3992);
				AddLabel(128, 85, 1160, "Tailor/Smith Bilgileri");
				AddLabel(70, 130, 67, "Tailoring:");
				AddLabel(70, 150, 1149, "Bod Hakknz:");
				AddLabel(70, 165, 1149, "Kalan Hak:");
				AddLabel(70, 180, 1149, "Sonraki Bod:");
				AddLabel(200, 150, 1149, pm.BODTailorMax.ToString() );
				AddLabel(200, 165, 1149, pm.BODTailor.ToString() );
				AddLabel(200, 180, 1149, pm.NextTailorBulkOrder.ToString().Substring( 0, 8 ) );
				AddLabel(70, 200, 67, "Blacksmithy:");
				AddLabel(70, 220, 1149, "Bod Hakknz:");
				AddLabel(70, 235, 1149, "Kalan Hak:");
				AddLabel(70, 250, 1149, "Sonraki Bod:");
				AddLabel(200, 220, 1149, pm.BODSmithMax.ToString() );
				AddLabel(200, 235, 1149, pm.BODSmith.ToString() );
				AddLabel(200, 250, 1149, pm.NextSmithBulkOrder.ToString().Substring( 0, 8 ) );
				AddLabel(70, 270, 67, "Dierleri:");
				AddLabel(70, 285, 1149, "Sonraki Bod:");
				AddLabel(200, 285, 1149, pm.BODLastTime.AddHours( 24 ).ToString().Substring( 0, 16 ) );
			}
		}
		[Usage( "Bodcu" )] 
		public static void BodcuCommand( CommandEventArgs e ) 
		{
			if ( e.Mobile.CantWalk || e.Mobile.Frozen )
				return;

			Mobile from = e.Mobile;
			if ( from.Skills.Blacksmith.Base < 100 && from.Skills.Tailoring.Base < 100 )
				from.SendMessage("Bod alabilen biri deilsiniz.");
			else
			{
				from.CloseGump( typeof ( BODAcceptGump ) );
				from.SendGump( new BODAcceptGump( e.Mobile ) );
			}
		}
		public class BODAcceptGump : Gump
		{
			public BODAcceptGump( Mobile from ) : base(0, 0)
			{
				PlayerMobile pm = from as PlayerMobile;
				if ( pm == null )
					return;

				String msg = "Eer sahip olduunuz BOD alma yetkisini baka bir craft karaktere aktarrsanz bu karakterin Blacksmithy ve Tailoring skillleri 50.0'a decektir. Isterseniz ayn karaktere tekrar Tailoring ya da Blacksmithy kasarak yine bod hakk kazanabilirsiniz. Bod haklarnz transfer etme ilemini kabul ediyor musunuz?";
				int bonus1 = pm.Skills.Blacksmith.Base >= 100 ? 1 : 0;
				int bonus2 = pm.Skills.Tailoring.Base >= 100 ? 1 : 0;

				AddPage(0);
				AddBackground(50, 50, 378, 330, 9270);
				AddImageTiled(61, 61, 355, 308, 2624);
				AddLabel(70, 65, 1160, "Bod Hakk Aktarm");
				AddHtml( 69, 84, 342, 103, msg, true, true);
				AddLabel(70, 190, 68, "Tailoring Hakk");
				AddLabel(70, 210, 68, "Blacksmith Hakk");
				AddLabel(200, 190, 1149, String.Format(": {0}", pm.BODTailorMax + bonus2) );
				AddLabel(200, 210, 1149, String.Format(": {0}", pm.BODSmithMax + bonus1) );
				AddButton(120, 250, 4011, 4013, 1, GumpButtonType.Reply, 0);
				AddButton(154, 250, 4005, 4007, 2, GumpButtonType.Reply, 0);
				AddLabel(192, 250, 1149, "Tailoring Haklarn Devret");
				AddButton(120, 275, 4011, 4013, 3, GumpButtonType.Reply, 0);
				AddButton(154, 275, 4005, 4007, 4, GumpButtonType.Reply, 0);
				AddLabel(192, 275, 1149, "Blacksmith Haklarn Devret");
				AddButton(154, 300, 4005, 4007, 5, GumpButtonType.Reply, 0);
				AddLabel(192, 300, 1149, "Tm Haklarn Devret");
				AddButton(217, 339, 241, 243, 0, GumpButtonType.Reply, 0);
				AddBackground(70, 250, 49, 23, 9350);
				AddBackground(70, 274, 49, 23, 9350);
				AddTextEntry(75, 254, 40, 16, 0, 1, "5");
				AddTextEntry(74, 277, 40, 16, 0, 2, "5");
			}
			public override void OnResponse( NetState state, RelayInfo info )
			{
				if ( info.ButtonID == 0 || state.Mobile == null || !( state.Mobile is PlayerMobile ) )
					return;
				int Secim = info.ButtonID;
				PlayerMobile from = state.Mobile as PlayerMobile;

				int bodTailor = 5;
				int bodSmith = 5;
				try{
					bodTailor = Convert.ToInt32( ( info.GetTextEntry( 1 ) ).Text.Trim() );
					bodSmith = Convert.ToInt32( ( info.GetTextEntry( 2 ) ).Text.Trim() );
				}
				catch{
					return;
				}
				if ( bodTailor > 100 || bodSmith > 100 || bodTailor < 1 || bodSmith < 1 )
				{
					from.SendMessage(0x22, "En az 1, en fazla 100 bod hakkn bir deed ekline getirebilirsin.");
					return;
				}

				if ( Secim == 2 )
					from.Target = new BODAcceptTarget( 1 );
				else if ( Secim == 4 )
					from.Target = new BODAcceptTarget( 2 );
				else if ( Secim == 5 )
					from.Target = new BODAcceptTarget( 5 );
				else if ( Secim == 1 )
				{
					if ( ScrollLimit[from] != null && ((DateTime)ScrollLimit[from]).AddSeconds( 30 ) > DateTime.Now )
						from.SendMessage(0x22, "Bu kadar ksa srede scroll kartamazsn.");
					else if ( from.BODTailorMax > bodTailor )
					{
						from.NextTailorBulkOrder = TimeSpan.FromHours( 6 );
						from.BODTailorMax = from.BODTailorMax - bodTailor;
						from.AddToBackpack( new TailorBODScroll( bodTailor ) );
						from.SendMessage(68, "{0} Tailoring BOD hakk scroll halinde antanza konulmutur.", bodTailor );

						ScrollLimit[from] = DateTime.Now;
					}
					else
						from.SendMessage(0x22, "Yetenein hari en az 1 fazladan Tailoring BOD hakk gereklidir.");
				}
				else if ( Secim == 3 )
				{
					if ( ScrollLimit[from] != null && ((DateTime)ScrollLimit[from]).AddSeconds( 30 ) > DateTime.Now )
						from.SendMessage(0x22, "Bu kadar ksa srede scroll kartamazsn.");
					else if ( from.BODSmithMax > bodSmith )
					{
						from.NextSmithBulkOrder = TimeSpan.FromHours( 6 );
						from.BODSmithMax = from.BODSmithMax - bodSmith;
						from.AddToBackpack( new SmithBODScroll( bodSmith ) );
						from.SendMessage(68, "{0} Blacksmith BOD hakk scroll halinde antanza konulmutur.", bodSmith );

						ScrollLimit[from] = DateTime.Now;
					}
					else
						from.SendMessage(0x22, "Yetenein hari en az 1 fazladan Blacksmith BOD hakk gereklidir.");
				}

				if ( Secim == 2 || Secim == 4 || Secim == 5 )
					from.SendMessage(1166, "Yetkinizi vereceiniz Tailor ya da Blacksmith karakteri sein...");
			}
		}
		public class BODAcceptTarget : Target
		{
			int style = 0;
			public BODAcceptTarget( int secim ) : base( -1, false, TargetFlags.None )
			{
				style = secim;
			}
			protected override void OnTarget( Mobile from, object o )
			{
				if ( !(o is PlayerMobile) )
					return;
				else
				{
					PlayerMobile pm = (PlayerMobile)o;
					PlayerMobile pm_from = (PlayerMobile)from;

					if ( style == 5 || style == 1 )
					{
						if ( from.Skills.Tailoring.Base >= 100 && pm.Skills.Tailoring.Base >= 100 && pm_from != pm )
						{
							int total = pm_from.BODTailorMax + 1;
							pm.BODTailorMax = pm.BODTailorMax + total;
							pm.SendMessage( String.Format("{0} adl oyuncu Tailor BOD alma haklarn size devretmitir. 6 saat sonra kullanabilirsiniz.", from.Name ) );
							pm.SendMessage( 68, String.Format("{0} Tailoring bod hakk kazandnz.", total ) );
							pm_from.BODTailorMax = 0;
							pm_from.BODTailor = 0;
							pm.NextTailorBulkOrder = TimeSpan.FromHours( 6 );
							from.Skills.Tailoring.Base = 50;
						}
					}
					if ( style == 5 || style == 2 )
					{
						if ( from.Skills.Blacksmith.Base >= 100 && pm.Skills.Blacksmith.Base >= 100 && pm_from != pm )
						{
							int total = pm_from.BODSmithMax + 1;
							pm.BODSmithMax = pm.BODSmithMax + total;
							pm.SendMessage( String.Format("{0} adl oyuncu Smith BOD alma haklarn size devretmitir. 6 saat sonra kullanabilirsiniz.", from.Name ) );
							pm.SendMessage( 68, String.Format("{0} Blacksmithy bod hakk kazandnz.", total ) );
							pm_from.BODSmithMax = 0;
							pm_from.BODSmith = 0;
							pm.NextSmithBulkOrder = TimeSpan.FromHours( 6 );
							from.Skills.Blacksmith.Base = 50;
						}
					}
				}
			}
		}
	}

	public class TailorBODScroll : Item
	{
		private int m_Count;
		[CommandProperty( AccessLevel.Administrator )]
		public int Count
		{
			get{ return m_Count; }
			set{ m_Count = value; }
		}
		[Constructable]
		public TailorBODScroll( int amount ) : base( 0x14F0 )
		{
			Weight = 1.0;
			Count = 1;
			LootType = LootType.Blessed;

			if ( amount > 0 && amount <= 100 )
				Count = amount;

			Name = String.Format("{0} Tailoring BOD Hakk", Count);
		}
		public TailorBODScroll( Serial serial ) : base( serial )
		{
		}
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
			writer.Write( (int) m_Count );
		}
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			m_Count = reader.ReadInt();
		}
		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) )
				from.SendMessage(0x22, "antanda kullanmalsn.");
			else if ( from.Skills.Tailoring.Base < 100.0 )
				from.SendMessage(0x22, "Gerekli Tailoring yeteneine sahip deilsin.");
			else if ( from is PlayerMobile )
			{
				from.FixedEffect( 0x376A, 1, 32 );

				PlayerMobile pm = from as PlayerMobile;
				pm.BODTailorMax = pm.BODTailorMax + Count;
				pm.NextTailorBulkOrder = TimeSpan.FromHours( 6 );

				from.SendMessage(68, "{0} Tailoring bod hakk kazandnz. Bod haklarnz grmek iin [Bod komutu kullanabilirsiniz..", Count);

				if ( this != null || !this.Deleted )
					this.Delete();
			}
		}
	}

	public class SmithBODScroll : Item
	{
		private int m_Count;
		[CommandProperty( AccessLevel.Administrator )]
		public int Count
		{
			get{ return m_Count; }
			set{ m_Count = value; }
		}
		[Constructable]
		public SmithBODScroll( int amount ) : base( 0x14F0 )
		{
			Weight = 1.0;
			Count = 1;
			LootType = LootType.Blessed;

			if ( amount > 0 && amount <= 100 )
				Count = amount;

			Name = String.Format("{0} Blacksmith BOD Hakk", Count);
		}
		public SmithBODScroll( Serial serial ) : base( serial )
		{
		}
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
			writer.Write( (int) m_Count );
		}
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			m_Count = reader.ReadInt();
		}
		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) )
				from.SendMessage(0x22, "antanda kullanmalsn.");
			else if ( from.Skills.Blacksmith.Base < 100.0 )
				from.SendMessage(0x22, "Gerekli Blacksmith yeteneine sahip deilsin.");
			else if ( from is PlayerMobile )
			{
				from.FixedEffect( 0x376A, 1, 32 );

				PlayerMobile pm = from as PlayerMobile;
				pm.BODSmithMax = pm.BODSmithMax + Count;
				pm.NextSmithBulkOrder = TimeSpan.FromHours( 6 );

				from.SendMessage(68, "{0} Blacksmith bod hakk kazandnz. Bod haklarnz grmek iin [Bod komutu kullanabilirsiniz..", Count);

				if ( this != null || !this.Deleted )
					this.Delete();
			}
		}
	}
}