// Web yelik Sistemi - RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

/*
   Bir phpbb foruma balanarak yelikler ekler ya da gnceller.
   Sadece PlainPassword ve CryptPassword geerlidir.

   AccountHandler.cs dosyasndaki;

   Eer verilerin alnaca forum veritabanndaki ifreler MD5 korumalysa:
   - public static PasswordProtection ProtectPasswords = PasswordProtection.Crypt;
   Deilse:
   - public static PasswordProtection ProtectPasswords = PasswordProtection.None;

   olmaldr.

   NOT: Aadaki veritaban bilgileri mutlaka doldurulmaldr!
*/

using System;
using System.Data;
using System.Data.Odbc;
using System.Data.SqlClient;
using System.Collections;
using System.Text;
using Server;
using Server.Misc;
using Server.Mobiles;
using Server.Accounting;

namespace Server.Accounting
{ 
	public class WebAccount
	{
		public static bool Enabled = false; // Sistem aktif edilsin mi?

		public const string DatabaseDriver = "{MySQL ODBC 3.51 Driver}";
		public const string DatabaseServer = "localhost"; // MySQL sunucusunun IP adresi
		public const string DatabaseName = "test"; // DB ad
		public const string DatabaseUserID = "root"; // DB kullanc ad
		public const string DatabasePassword = ""; // DB kullanc ifresi
		public const string DatabaseTableName = "phpbb_users"; // PHPBB forum yelik tablosu

		private static OdbcConnection m_Connection;
		private static OdbcCommand m_Command;

		public static void Initialize()
		{
			if ( Enabled )
				EventSink.WorldSave += new WorldSaveEventHandler( EventSink_WorldSave );
		}
		public static void EventSink_WorldSave( WorldSaveEventArgs e )
		{
			int Eklenen = 0;
			int Duzenlenen = 0;

			if ( Baglan() )
			{
				try{
					Console.WriteLine( "Web Account: yelikler ekleniyor / gncelleniyor..");
					m_Command.CommandText = "SELECT user_id, user_active, username, user_password FROM " + DatabaseTableName;
					OdbcDataReader reader = m_Command.ExecuteReader();

					while( reader.Read() )
					{
						string id = reader.GetString( 0 );
						string active = reader.GetString( 1 );
						string user = reader.GetString( 2 );
						string pass = reader.GetString( 3 );

						Account account = (Account) Accounts.GetAccount( user );
						if ( Utility.ToInt32( id ) > -1 && account == null )
						{
							Accounts.Add( new Account( user, pass, true ) );
							Eklenen++;
						}
						else if ( account != null && active == "1" && user != null && pass != null && !( account.CheckPassword( pass ) ) )
						{
							if ( AccountHandler.ProtectPasswords == PasswordProtection.None )
								account.PlainPassword = pass;
							else if ( AccountHandler.ProtectPasswords == PasswordProtection.Crypt )
								account.CryptPassword = SetPass( pass.ToUpper() );
							Duzenlenen++;
						}
					}

					BaglantiKes();
				}
				catch{
				}
			}

			Console.WriteLine( String.Format( "Web Account: Tamamland. {0} ekleme, {1} gncelleme yapld.", Eklenen, Duzenlenen ) );
		}

		private static bool Baglan()
		{
			try{
				String m_String = String.Format("DRIVER={0};SERVER={1};DATABASE={2};UID={3};PASSWORD={4};", DatabaseDriver, DatabaseServer, DatabaseName, DatabaseUserID, DatabasePassword);

				m_Connection = new OdbcConnection( m_String );
				m_Connection.Open();

				m_Command = new OdbcCommand( "use " + DatabaseName + ";", m_Connection);
				m_Command.ExecuteNonQuery();

				return true;
			}
			catch{
			}

			return false;
		}
		private static void BaglantiKes()
		{
			m_Connection.Close();
			m_Connection = null;
			m_Command = null;
		}
		public static string SetPass( string pass )
		{
			string newPass = "";
			for ( int i = 0; i < pass.Length; i++ )
			{
				newPass = newPass + pass.Substring( i, 1 );

				if ( i % 2 == 1 && i < pass.Length - 1 )
					newPass = newPass + "-";
			}

			return newPass;
		}
	}
}