// RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

using System;
using System.Collections;
using Server.Items;

namespace Server.Mobiles
{
	[CorpseName( "a cleaner corpse" )]
	public class Temizleyici : BaseCreature
	{
		[Constructable]
		public Temizleyici() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "Temizleyici";

			Body = 51;
			BaseSoundID = 456;
			Hue = 1150;
			SetStr( 22, 34 );
			SetDex( 16, 21 );
			SetInt( 16, 20 );
			SetHits( 15, 19 );
			SetDamage( 1, 5 );
			VirtualArmor = 70;
			Blessed = true;
		}
		public override void OnThink()
		{
			base.OnThink();
			ArrayList list = new ArrayList();
			foreach ( Item item in this.GetItemsInRange( 8 ) )
			{
				if ( item.Movable || item is Corpse && !(((Corpse)item).Owner is PlayerMobile) )
					list.Add( item );
			}
			for ( int i = 0; i < list.Count; ++i )
				((Item)list[i]).Delete();
		}
		public Temizleyici( Serial serial ) : base( serial ) 
		{ 
		} 
		public override void Serialize( GenericWriter writer ) 
		{ 
			base.Serialize( writer ); 
			writer.Write( (int) 0 ); // version 
		} 
		public override void Deserialize( GenericReader reader ) 
		{ 
			base.Deserialize( reader ); 
			int version = reader.ReadInt(); 
		} 
	} 
}